/*
 * Decompiled with CFR 0.152.
 */
package skeletonapplet;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.net.URL;
import java.util.List;
import javax.swing.ProgressMonitor;
import skeletonapplet.AtomicDownloader;
import skeletonapplet.ChunkInfo;
import skeletonapplet.FileInfo;
import skeletonapplet.Utilities;

public class ChunkDownloader {
    protected URL baseUrl;
    protected FileInfo fileInfo;
    protected byte[] downloadedData;
    protected File workDirectory;

    public ChunkDownloader(URL uRL, FileInfo fileInfo, File file) {
        this.baseUrl = uRL;
        this.fileInfo = fileInfo;
        this.workDirectory = file;
    }

    public byte[] download(ProgressMonitor progressMonitor, int n) {
        return this.download(progressMonitor, n, 1);
    }

    public byte[] download(ProgressMonitor progressMonitor, int n, int n2) {
        if (n2 == 0) {
            return null;
        }
        if (!this.fileInfo.hasChunks()) {
            AtomicDownloader atomicDownloader = new AtomicDownloader(this.baseUrl, this.fileInfo);
            return atomicDownloader.download(progressMonitor, n, n2);
        }
        try {
            this.downloadedData = this.innerDownload(progressMonitor, n, n2);
            return this.downloadedData;
        }
        catch (Throwable throwable) {
            Utilities.checkSwallow(throwable);
            return null;
        }
    }

    protected byte[] innerDownload(ProgressMonitor progressMonitor, int n, int n2) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n3 = n;
        List list = this.fileInfo.getChunkInfoList().getChunkInfos();
        for (int i = 0; i < list.size(); ++i) {
            Object object;
            ChunkInfo chunkInfo = (ChunkInfo)list.get(i);
            File file = new File(this.workDirectory, chunkInfo.getBaseFileName());
            if (!file.exists() || !chunkInfo.validate(file)) {
                object = new AtomicDownloader(this.baseUrl, chunkInfo);
                byte[] byArray = ((AtomicDownloader)object).download(progressMonitor, n3);
                n3 += byArray.length;
                if (chunkInfo.validate(byArray)) {
                    byteArrayOutputStream.write(byArray, 0, byArray.length);
                    Utilities.writeBytes(file, byArray);
                    continue;
                }
                return null;
            }
            object = Utilities.readBytes(file);
            progressMonitor.setProgress(n3 += ((byte[])object).length);
            byteArrayOutputStream.write((byte[])object, 0, ((Object)object).length);
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        return (byte[])(this.fileInfo.validate(byArray) ? byArray : null);
    }
}

